<?php

class XMLRPCParser {
	
	public function callService($remoteMethod, $parameters, $remoteServer, $remotePath, $port=80) {
		/*
		 * Fasada do wykonywania żądań XML-RPC.
		 */
		
		$requestXML = xmlrpc_encode_request($remoteMethod, $parameters);
		$fullRequest = $this->createPostRequest($remoteServer, $remotePath, $requestXML);
		$response = $this->send($remoteServer, $port, $fullRequest);
		return xmlrpc_decode($response);
	}

	private function createPostRequest($remoteServer, $remotePath, $requestBody) {
		
		/* 
		 * Tworzy pełne żądanie XML-RPC z nagłówkami.
		 */
		$theRequest = "POST " . $remotePath . " HTTP/1.0\n" .
		"Host: " . $remoteServer . "\n" .
		"User-Agent: XML-RPC Client\n" .
		"Content-Type: text/xml\n" .
		"Content-Length: " .strlen($requestBody) . "\n" .
		"\n" . $requestBody . "\n";
		return $theRequest;
	}
	
	private function send($remoteServer, $remotePort, $fullXMLRPCRequest) {
		
		/*
		 * Wysyła żądanie XML-RPC za pomocą gniazd.
		 */
		
		$headers = '';
		$data = '';
		
		$socket = fsockopen($remoteServer, $remotePort);
		fwrite($socket, $fullXMLRPCRequest);
	
		while ($str = trim(fgets($socket))) {
			$headers .= $str . '\n';	
		}
		
		$data = '';
		while  (!feof($socket)) {
			$data .= fgets($socket);	
		}
		fclose($socket);
		return $data;
	
	}
	
	public function processXMLRPCResponse($data) {

		/* 
		 * Ta metoda jest jednym ze sposobów wypisywania na ekranie
		 * dowolnej odpowiedzi XML-RPC.
		 */
		
			if (xmlrpc_is_fault($data)) {
				echo 'Kod błędu: ' . $data['faultCode'] . "\n";
				echo 'Komunikat błędu: ' . $data['faultString'];
			} else {		
				
				if (is_array($data)) {
					var_dump($data);
				} else {
					echo $data;		
				}
				
			}	
			
	}

}

?>